<?php
include_once('connection.php');

$trackid = "";
$courier = "";
$package = "";
$mode = "";
$product = "";
$quantity = "";
$totalfreight = "";
$crn = "";

$errorMessage = "";
$successMessage = "";

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    // <!-- get method: show the data of the client -->

    if (!isset($_GET["trackid"])) {
        header("location: /transpor/Admins.php");
        exit;
    }

$trackid = $_GET["trackid"];

// read the row of the selected client from the database table
$sql = "SELECT * FROM consignment_details WHERE trackid=?";
$stmt = $con->prepare($sql);
$stmt->bind_param("s", $trackid);  // Use "s" for string (VARCHAR) type
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
$stmt->close();

if (!$row) {
    header("location: /transpor/Admins.php");
    exit;
}
    $trackid = $row["trackid"];
    $courier = $row["courier"];
    $package = $row["package"];
    $mode = $row["mode"];
    $product = $row["product"];
    $quantity = $row["quantity"];
    $totalfreight = $row["totalfreight"];
    $crn = $row["crn"];
} else {
    // <!-- post method: update the data of the client -->

    $trackid = $_POST["trackid"];
    $courier = $_POST["courier"];
    $package = $_POST["package"];
    $mode = $_POST["mode"];
    $product = $_POST["product"];
    $quantity = $_POST["quantity"];
    $totalfreight = $_POST["totalfreight"];
    $crn = $_POST["crn"];

    do {
        if (empty($trackid) || empty($courier) || empty($package) || empty($mode) || empty($product) || empty($quantity) || empty($totalfreight) || empty($crn)) {
            $errorMessage = "All fields are required";
            break;
        }

        $sql = "UPDATE consignment_details
               SET trackid = ?, courier = ?, package = ?, mode = ?, product = ?, quantity = ?, totalfreight = ?, crn = ? 
               WHERE trackid = ?";
        $stmt = $con->prepare($sql);
        $stmt->bind_param("sssssssss", $trackid, $courier, $package, $mode, $product, $quantity, $totalfreight, $crn, $trackid);
        $result = $stmt->execute();
        $stmt->close();

        if (!$result) {
            $errorMessage = "Invalid query: " . $con->error;
            break;
        }

        $successMessage = "Client updated successfully";

        header("location: /transpor/Admins.php");
        exit;
    } while (true);
}
?>


<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Unit Cargo - Logistics</title>
    <link rel="shortcut icon" href="assets/img/favicon.jpg">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>

<body>
    <div class="container my-5">
        <h2>New Client Details</h2>

        <?php
        if (!empty($errorMessage)) {
            echo "
            <div class='alert alert-warning alert-dismissible fade show' role='alert'>
                <strong>$errorMessage</strong>
                <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='close'></button>
            </div> 
            ";
        }

        if (!empty($successMessage)) {
            echo "
            <div class='alert alert-success alert-dismissible fade show' role='alert'>
                <strong>$successMessage</strong>
                <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='close'></button>
            </div> 
            ";
        }
        ?>
		<form method="post">
			<input type="hidden" name="trackid" value="<?php echo $trackid; ?>">
			<div class="row mb-3">
				<label class="col-sm-3 col-form-label">Courier</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" name="courier" value="<?php echo $courier; ?>">
				</div>
			</div>
			<div class="row mb-3">
				<label class="col-sm-3 col-form-label">Package</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" name="package" value="<?php echo $package; ?>">
				</div>
			</div>
			<div class="row mb-3">
				<label class="col-sm-3 col-form-label">Mode</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" name="mode" value="<?php echo $mode; ?>">
				</div>
			</div>
			<div class="row mb-3">
				<label class="col-sm-3 col-form-label">Product</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" name="product" value="<?php echo $product; ?>">
				</div>
			</div>
			<div class="row mb-3">
				<label class="col-sm-3 col-form-label">Quantity</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" name="quantity" value="<?php echo $quantity; ?>">
				</div>
			</div>
			<div class="row mb-3">
				<label class="col-sm-3 col-form-label">Total-Freight</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" name="totalfreight" value="<?php echo $totalfreight; ?>">
				</div>
			</div>
			<div class="row mb-3">
				<label class="col-sm-3 col-form-label">Courier Ref No</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" name="crn" value="<?php echo $crn; ?>">
				</div>
			</div>


			<?php
				if ( !empty($successMessage) ) {

				}
			?>

			<div class="row mb-3">
				<div class="offset-sm-3 col-sm-3 d-grid">
					<button type="submit" class="btn btn-primary">Submit</button>
				</div>
				<div class="col-sm-3 d-grid">
					<a class="btn btn-outline-primary" href="/transpor/Admins.php" role="button">Cancel</a>
				</div>

			</div>
		</form>
	</div>

</body>
</html>