<!DOCTYPE html>
<html lang="en">

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <!-- ========== Meta Tags ========== -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="author" content="modinatheme">
    <!-- ======== Page title ============ -->
    <title>Unit Cargo - Logistics </title>
	<link rel="canonical" href="https://Unitcargologistics.com" />
    <!-- ========== Favicon Icon ========== -->
    <link rel="shortcut icon" href="assets/img/favicon.jpg">
    <!-- ===========  All Stylesheet ================= -->
    <!--  Icon css plugins -->
    <link rel="stylesheet" href="assets/css/icons.css">
    <!--  animate css plugins -->
    <link rel="stylesheet" href="assets/css/animate.css">
    <!--  slick css plugins -->
    <link rel="stylesheet" href="assets/css/slick.css">
    <!--  magnific-popup css plugins -->
    <link rel="stylesheet" href="assets/css/magnific-popup.css">
    <!-- metis menu css file -->
    <link rel="stylesheet" href="assets/css/metismenu.css">
    <!-- select2 css file -->
    <link rel="stylesheet" href="assets/css/nice-select2.css">
    <!--  Bootstrap css plugins -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <!--  main style css file -->
    <link rel="stylesheet" href="assets/css/style.css">
    <!-- template main style css file -->
    <link rel="stylesheet" href="style.css">
</head>
<body class="body-wrapper">    
    <div class="top-bar-wrapper d-none d-sm-block">
        <div class="container d-flex justify-content-between align-items-center">
            <div class="top-left">
                <a href="tel:+1 215 539 5263"><i class="fal fa-phone-volume"></i>+1-215-539-5263</a>
                <a href="mailto:unitcargologistics@gmail.com"><i class="fal fa-envelope"></i>unitcargologistics@gmail.com</a>
                <a href="#"><i class="fal fa-map-marker-alt"></i>17 Stella-klein-low Weg, Vienna, Vienna, 1020, Austria</a>
            </div>
            <div class="top-right d-none d-md-block">
                <div class="social-pages">
                    <a href="#"><i class="fab fa-facebook-f" aria-hidden="true"></i></a>
                    <a href="#"><i class="fab fa-twitter" aria-hidden="true"></i></a>
                    <a href="#"><i class="fab fa-linkedin-in" aria-hidden="true"></i></a>
                    <a href="#"><i class="fab fa-youtube" aria-hidden="true"></i></a> 
                    <a href="#"><i class="fab fa-skype" aria-hidden="true"></i></a> 
                </div>
            </div>
        </div>
    </div>
    <header class="header-1">
        <div class="container">
            <div class="row align-items-center justify-content-between">
                <div class="col-lg-3 col-sm-5 col-md-4 col-6 pr-lg-5">
                    <div class="logo">
                        <a href="index.php">
                        <img src="assets/img/logo.jpg"  alt="Unitcargologistics">       
                        </a>
                    </div>
                </div>
                <div class="col-lg-9 text-end p-lg-0 d-none d-lg-flex justify-content-between align-items-center">
                    <div class="menu-wrap">
                        <div class="main-menu">
                            <ul>
                                <li><a href="index.php">Home</a>
                                </li>
                                <li><a href="about.html">About</a> </li>
                                <li><a href="services.html">Services</a></li>
                                <li><a href="news.html">News</a></li>
                                <li><a href="delivery.html">Delivery</a></li>
                                <li><a href="contact.html">Contact</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="header-right-element">
                        <a href="search.php" class="theme-btn">Track <i class="fal fa-long-arrow-right"></i></a>
                        <a href="#" class="search-btn"><i class="fal fa-search"></i></a>
                        <div class="search-box">
                            <form action="#">
                                <input type="text" placeholder="Search">
                                <button type="submit"><i class="fal fa-search"></i></button>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="d-block d-lg-none col-sm-1 col-md-8 col-6">
                    <div class="mobile-nav-wrap">
                        <div id="hamburger"><i class="fal fa-bars"></i></div>
                        <!-- mobile menu - responsive menu  -->
                        <div class="mobile-nav">
                            <button type="button" class="close-nav">
                                <i class="fal fa-times-circle"></i>
                            </button>
                            <nav class="sidebar-nav">
                                <ul class="metismenu" id="mobile-menu">
                                    <li><a class="has-arrow" href="index.php">Home</a></li>
                                    <li><a href="about.html">about</a></li>
                                    <li><a href="services.html">services</a></li>
                                    <li>
                                        <a class="has-arrow" href="#">Pages</a>
                                        <ul class="sub-menu">
                                            <li><a href="faq.html">faq</a></li>
                                            <li><a href="services-details.html">services details</a></li>
                                            <li><a href="team.html">Team</a></li>
                                            <li><a href="404.html">404</a></li>
                                        </ul>
                                    </li>
                                    <li><a href="news.html">News</a></li>
                                    <li><a href="contact.html">Contact</a></li>
                                </ul>
                            </nav>
                            <div class="action-bar text-white">
                                <div class="single-info-element">
                                    <div class="icon">
                                        <i class="fal fa-map-marked-alt"></i>
                                    </div>
                                    <div class="text">
                                        <h5>Visit our location:</h5>
                                        <span>17 Stella-klein-low Weg, Vienna, Vienna, 1020, Austria</span>
                                    </div>
                                </div>
                                <div class="single-info-element">
                                    <div class="icon">
                                        <i class="fal fa-clock"></i>
                                    </div>
                                    <div class="text">
                                        <h5>Opening Hours:</h5>
                                        <span>Mon-Fri 8am-5pm</span>
                                    </div>
                                </div>
                                <div class="single-info-element">
                                    <div class="icon">
                                        <i class="fal fa-envelope"></i>
                                    </div>
                                    <div class="text">
                                        <h5>Send us mail</h5>
                                        <span>unitcargologistics@gmail.com</span>
                                    </div>
                                </div>
                                <div class="call-us">
                                    <div class="icon text-white">
                                        <i class="fal fa-phone-volume"></i>
                                    </div>
                                    <div class="text">
                                        <h5>Troll fre number</h5>
                                        <span>+1-215-539-5263</span>
                                    </div>
                                </div>
                                <a href="search.php" class="theme-btn mt-4">Track Your Shipment</a>
                            </div>
                        </div> 
                    </div>
                    <div class="overlay"></div>
                </div>
            </div>
        </div>
    </header>
    <section class="hero-wrapper hero-1">
        <div class="hero-slider-active unitcargologistics-dots">
            <div class="single-slide">
                <div class="slide-bg bg-cover wow zoomIn" style="background-image: url('assets/img/home1/slide1.jpg');">
                </div>
                <div class="container">
                    <div class="row">
                        <div class="col-12 col-xxl-6 col-lg-8 col-sm-10">
                            <div class="hero-contents pe-lg-3 text-white">
                                <h1 class="fs-lg animated" data-animation-in="fadeInRight" data-delay-in="0.2">Innovative
                                    thing <span>Provide</span></h1>
                                <p class="pe-lg-5 mb-4 animated" data-animation-in="fadeInRight" data-delay-in="0.5">We are committed to providing our customers with exceptional service while offering our employees </p>
                                <a href="search.php" data-animation-in="fadeInRight" data-delay-in="0.8" class="theme-btn me-sm-4 mt-4 animated">Track your shipment</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="slide-pop-video-box-wrapper d-flex text-white align-items-center" data-animation-in="fadeInRight" data-delay-in="1s">
                    <div class="text col-6">
                        <h6>We're thriving and building better</h6>
                    </div>
                    <div class="video-wrapper bg-overlay bg-cover bg-center col-6 justify-content-center align-items-center" style="background-image: url('assets/img/faq-video-pup.jpg')">
                        <a href="https://www.youtube.com/watch?v=E1xkXZs0cAQ" class="popup-video play-video"><i class="fas fa-play"></i></a> 
                    </div>
                </div>
            </div>
            <div class="single-slide">
                <div class="slide-bg bg-cover" style="background-image: url('assets/img/home1/slide2.jpg');">
                </div>
                <div class="container">
                    <div class="row">
                        <div class="col-12 col-xxl-6 col-lg-8 col-sm-10">
                            <div class="hero-contents pe-lg-3 text-white">
                                <h1 class="fs-lg animated" data-animation-in="fadeInRight" data-delay-in="0.2">best Logistics in the <span>World</span></h1>
                                <p class="pe-lg-5 mb-4" data-animation-in="fadeInRight" data-delay-in="0.5">We are committed to providing our customers with exceptional service while offering our employees </p>
                                <a href="search.php" data-animation-in="fadeInRight" data-delay-in="0.8" class="theme-btn me-sm-4 mt-4">Track your shipment</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="slide-pop-video-box-wrapper d-flex text-white align-items-center" data-animation-in="fadeInRight" data-delay-in="1s">
                    <div class="text col-6">
                        <h6>We're thriving and building better</h6>
                    </div>
                    <div class="video-wrapper bg-overlay bg-cover bg-center col-6 justify-content-center align-items-center" style="background-image: url('assets/img/faq-video-pup.jpg')">
                        <a href="https://www.youtube.com/watch?v=E1xkXZs0cAQ" class="popup-video play-video"><i class="fas fa-play"></i></a> 
                    </div>
                </div>
            </div>
        </div>
        <svg xmlns="http://www.w3.org/2000/svg" style="display: none;">
            <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44 44" width="44px" height="44px" id="circle" fill="none" stroke="currentColor">
                <circle r="20" cy="22" cx="22" id="unitcargologisticscircle" />
            </symbol>
        </svg>
    </section>
    <section class="about-us-wrapper section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-5 text-center text-lg-start">
                    <div class="about-img">
                        <img src="assets/img/about-air.jpg" alt="">
                    </div>
                </div>
                <div class="col-lg-7 mt-5 mt-lg-0 ps-lg-5">
                    <div class="block-contents">
                        <div class="section-title">
                            <h5 class="textleft relative">about</h5>
                            <span>Since from 2000</span>
                            <h2>Company <span>Overview</span></h2>
                        </div>
                    </div>
                    <div class="about-info-contents">
                        <p>Unitcargologistics is the world’s driving worldwide coordinations supplier. we uphold industry and exchange the worldwide trade of merchandise through land transport.
                        </p>
                        <p>Our worth added administrations guarantee the progression of products proceeds consistently and supply chains stay lean and streamlined for progress.</p>
                    </div>
                    <div class="company-ceo d-flex align-items-center">
                        <div class="ceo-img bg-cover" style="background-image: url('assets/img/man-img.jpg')"></div>
                        <div class="ceo-info">
                            <h5>Alexis D. Denzol</h5>
                            <span>Head Of Idea</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="our-service-wrapper fix theme-bg section-padding">
        <div class="container">
            <div class="row">
                <div class="col-md-7 col-9">
                    <div class="block-contents">
                        <div class="section-title">
                            <h5 class="textleft">Service</h5>
                            <span>Featured Service</span>
                            <h2>What <span>We Do</span></h2>
                        </div>
                    </div>
                </div>
                <div class="col-md-5 ps-0 col-3 text-end">
                    <div class="services-carousel-nav-prev"><i class="fal fa-long-arrow-left"></i></div>
                    <div class="services-carousel-nav-next"><i class="fal fa-long-arrow-right"></i></div>
                </div>
            </div>
            <div class="col-md-12 col-12">
                <div class="services-carousel-active">
                    <div class="single-service-card">
                        <div class="service-banner-img bg-cover" style="background-image: url('assets/img/services/air.jpg')"></div>
                        <div class="content">
                            <h3><a href="services-details.html">Air Freight</a></h3>
                            <p>As a leader in global air freight forwarding, OIA Global excels in providing tailored transportation</p>
                        </div>
                    </div>
                    <div class="single-service-card">
                        <div class="service-banner-img bg-cover" style="background-image: url('assets/img/services/ship.jpg')"></div>
                        <div class="content">
                            <h3><a href="services-details.html">Ocean Freight</a></h3>
                            <p>Ocean Freight plays perhaps the most vital role in most transportation and supply chain solutions.</p>
                        </div>
                    </div>
                    <div class="single-service-card">
                        <div class="service-banner-img bg-cover" style="background-image: url('assets/img/services/road.jpg')"></div>
                        <div class="content">
                            <h3><a href="services-details.html">Road Freight</a></h3>
                            <p>Cargo are transported at some stage of their journey along the world’s roads where we give you a reassuring presence.</p>
                        </div>
                    </div>
                    <div class="single-service-card">
                        <div class="service-banner-img bg-cover" style="background-image: url('assets/img/services/warehouse.jpg')"></div>
                        <div class="content">
                            <h3><a href="services-details.html">Warehousing</a></h3>
                            <p>Package and store your things effectively and securely to make sure them in storage. best warehouse for your products.</p>
                        </div>
                    </div>
                    <div class="single-service-card">
                        <div class="service-banner-img bg-cover" style="background-image: url('assets/img/services/drone-fright.jpg')"></div>
                        <div class="content">
                            <h3><a href="services-details.html">Drone Freight</a></h3>
                            <p>Ship are transported at some stage of their journey along the world’s roads where we give you a reassuring presence.</p>
                        </div>
                    </div>
                    <div class="single-service-card">
                        <div class="service-banner-img bg-cover" style="background-image: url('assets/img/services/rail.jpg')"></div>
                        <div class="content">
                            <h3><a href="services-details.html">Continental Rail</a></h3>
                            <p>Continental Rail are transported at some stage of their journey along the world’s roads where we give you a presence.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="funfact-countdown-wrapper fix">
        <div class="container-fluid p-0">
            <div class="row no-padding">
                <div class="col-lg-3 col-md-6 col-12">
                    <div class="single-funfact-item">
                        <div class="icon">
                            <img src="assets/img/icons/map-classic.png" alt="">
                        </div>
                        <div class="countdown">
                            <h2>8700</h2>
                            <span>All Over The World</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-12">
                    <div class="single-funfact-item">
                        <div class="icon">
                            <img src="assets/img/icons/plan.png" alt="">
                        </div>
                        <div class="countdown">
                            <h2>5644</h2>
                            <span>All Over The World</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-12">
                    <div class="single-funfact-item">
                        <div class="icon">
                            <img src="assets/img/icons/box.png" alt="">
                        </div>
                        <div class="countdown">
                            <h2>2390</h2>
                            <span>All Over The World</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-12">
                    <div class="single-funfact-item">
                        <div class="icon">
                            <img src="assets/img/icons/cup.png" alt="">
                        </div>
                        <div class="countdown">
                            <h2>1150</h2>
                            <span>All Over The World</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="our-team-wrapper section-padding">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <div class="block-contents mb-20">
                        <div class="section-title">
                            <h5 class="textleft">team</h5>
                            <span>Our Team</span>
                            <h2>Meet Our <span>Amazing Team</span></h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xl-3 col-md-6 col-12">
                    <div class="team-member-card bg-cover" style="background-image: url('assets/img/team/1.jpg')">
                        <div class="profile-info-card">
                            <span>Founder</span>
                            <h5><a href="team-details.html">Alaxis D. Dowson</a></h5>
                            <div class="social-link">
                                <a href="#"><i class="fab fa-facebook-f"></i></a>
                                <a href="#"><i class="fab fa-twitter"></i></a>
                                <a href="#"><i class="fab fa-instagram"></i></a>
                                <a href="#"><i class="fab fa-youtube"></i></a>
                                <a href="#"><i class="fab fa-linkedin-in"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-12">
                    <div class="team-member-card bg-cover" style="background-image: url('assets/img/team/2.jpg')">
                        <div class="profile-info-card">
                            <span>Founder</span>
                            <h5><a href="team-details.html">Alaxis D. Dowson</a></h5>
                            <div class="social-link">
                                <a href="#"><i class="fab fa-facebook-f"></i></a>
                                <a href="#"><i class="fab fa-twitter"></i></a>
                                <a href="#"><i class="fab fa-instagram"></i></a>
                                <a href="#"><i class="fab fa-youtube"></i></a>
                                <a href="#"><i class="fab fa-linkedin-in"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-12">
                    <div class="team-member-card bg-cover" style="background-image: url('assets/img/team/3.jpg')">
                        <div class="profile-info-card">
                            <span>Founder</span>
                            <h5><a href="team-details.html">Alaxis D. Dowson</a></h5>
                            <div class="social-link">
                                <a href="#"><i class="fab fa-facebook-f"></i></a>
                                <a href="#"><i class="fab fa-twitter"></i></a>
                                <a href="#"><i class="fab fa-instagram"></i></a>
                                <a href="#"><i class="fab fa-youtube"></i></a>
                                <a href="#"><i class="fab fa-linkedin-in"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-12">
                    <div class="team-member-card bg-cover" style="background-image: url('assets/img/team/4.jpg')">
                        <div class="profile-info-card">
                            <span>Support</span>
                            <h5><a href="team-details.html">Salman Ahmed</a></h5>
                            <div class="social-link">
                                <a href="#"><i class="fab fa-facebook-f"></i></a>
                                <a href="#"><i class="fab fa-twitter"></i></a>
                                <a href="#"><i class="fab fa-instagram"></i></a>
                                <a href="#"><i class="fab fa-youtube"></i></a>
                                <a href="#"><i class="fab fa-linkedin-in"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="request-a-quote-section theme-bg bg-cover calculate-wrapper section-padding" style="background-image: url('assets/img/cost-bg.jpg')">
        <div class="container">
            <div class="row">
                <div class="col-xl-5 col-12">
                    <div class="block-contents mb-20 pr-30">
                        <div class="section-title">
                            <h5 class="textleft">quote</h5>
                            <span>Request a quote</span>
                            <h2>Cost <span>Calculator</span></h2>
                            <p class="text-white">You can know the Price for your Transportation in Advance. We Offers intellgent concepts for road and tail and well as complex special transport services</p>
                        </div>
                    </div>
                    <div class="row me-xl-5 text-white">
                        <div class="col-sm-6">
                            <div class="single-request-element">
                                <div class="icon">
                                    <i class="fal fa-warehouse"></i>
                                </div>
                                <h6>Warehouse</h6>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="single-request-element">
                                <div class="icon">
                                    <i class="fal fa-location"></i>
                                </div>
                                <h6>Online Tracking</h6>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="single-request-element">
                                <div class="icon">
                                    <i class="fal fa-headset"></i>
                                </div>
                                <h6>Support 24/7</h6>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="single-request-element">
                                <div class="icon">
                                    <i class="fal fa-shield-check"></i>
                                </div>
                                <h6>Cargo Insurance</h6>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-7 col-12">
                    <div class="request-quote-form-wrapper mt-5 mt-xl-0 ms-xl-3">
                        <h4>Personal & Shipment data</h4>
                        <div class="request-quote-form">
                            <form method="post" action="state.php">
                                <div class="row d-flex align-item-center">
                                    <div class="col-sm-6 col-12">
                                        <input type="text" name="sendername" placeholder="Sender's Name">
                                    </div>
                                    <div class="col-sm-6 col-12">
                                        <input type="email" name="senderemail" placeholder="Sender's Email">
                                    </div>
                                    <div class="col-sm-6 col-12">
                                        <input type="number" name="sendercontact" placeholder="Sender's Contact">
                                    </div>
                                    <div class="col-sm-6 col-12">
                                        <input type="text" name="senderaddress" placeholder="Sender's Address">
                                    </div>
                                    <div class="col-sm-6 col-12">
                                        <input type="text" name="dispatchlocation" placeholder="Dispatch Location">
                                    </div>
                                    <div class="col-sm-6 col-12">
                                        <input type="text" name="receivername" placeholder="Receiver's Name">
                                    </div>
                                    <div class="col-sm-6 col-12">
                                        <input type="number" name="receivercontact" placeholder="Receiver's Contact">
                                    </div>
                                    <div class="col-sm-6 col-12">
                                        <input type="email" name="receiveremail" placeholder="Receiver's Email">
                                    </div>
                                    <div class="col-sm-6 col-12">
                                        <input type="text" name="receiveraddress" placeholder="Receiver's Address">
                                    </div>
                                    <div class="col-sm-6 col-12">
                                        <select name="ftype" class="wide" id="unitcargologistics" >
                                            <option value="type">Freight type</option>
                                            <option value="air">Air Freight</option>
                                            <option value="ship">Ship Freight</option>
                                            <option value="cargo">Cargo Freight</option>
                                            <option value="road">Road Freight</option>
                                            <option value="rail">rail Freight</option>
                                        </select>
                                    </div>
                                    <div class="col-sm-6 col-12">
                                        <input type="date" name="edd" placeholder="Expected Delivery Date">
                                    </div>
                                    <div class="col-sm-12">
                                        <input type="submit" name="send" class="theme-btn" value="SUBMIT">
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="our-price-wrapper section-padding">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="block-contents mb-60">
                        <div class="section-title text-center">
                            <h5 class="text-center">price</h5>
                            <span>Best Pricing</span>
                            <h2>The Right <span>Price for you</span></h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="single-price-bar">
                <div class="row align-items-center">
                    <div class="col-xl-2">
                        <div class="package-name">
                            <h3>One Pack</h3>
                        </div>
                    </div>
                    <div class="col-xl-5 pe-xl-0">
                        <div class="package-features">
                            <span>Custom business rules</span>
                            <span>1 warehouse</span>
                        </div>
                    </div>
                    <div class="col-xl-2">
                        <div class="package-price">
                            <h2><span>49</span>USD</h2>
                        </div>
                    </div>
                    <div class="col-xl-3 text-xl-end">
                        <a href="#" class="theme-btn minimal-btn">get started <i class="fal fa-long-arrow-right"></i></a>
                    </div>
                </div>
            </div>
            <div class="single-price-bar">
                <div class="row align-items-center">
                    <div class="col-xl-2">
                        <div class="package-name">
                            <h3>Starter Pack</h3>
                        </div>
                    </div>
                    <div class="col-xl-5 pe-xl-0">
                        <div class="package-features">
                            <span>Custom business rules</span>
                            <span>2 warehouse</span>
                            <span>Real-time rate</span>
                        </div>
                    </div>
                    <div class="col-xl-2">
                        <div class="package-price">
                            <h2><span>100</span>USD</h2>
                        </div>
                    </div>
                    <div class="col-xl-3 text-xl-end">
                        <a href="#" class="theme-btn minimal-btn">get started <i class="fal fa-long-arrow-right"></i></a>
                    </div>
                </div>
            </div>
            <div class="single-price-bar active">
                <div class="row align-items-center">
                    <div class="col-xl-2">
                        <div class="package-name">
                            <h3>Business Pack</h3>
                        </div>
                    </div>
                    <div class="col-xl-5 pe-xl-0">
                        <div class="package-features">
                            <span>Pro business rules</span>
                            <span>10 warehouse</span>
                            <span>Real-time rate</span>
                        </div>
                    </div>
                    <div class="col-xl-2">
                        <div class="package-price">
                            <h2><span>149</span>USD</h2>
                        </div>
                    </div>
                    <div class="col-xl-3 text-xl-end">
                        <a href="#" class="theme-btn minimal-btn">get started <i class="fal fa-long-arrow-right"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="testimonial-wrapper section-bg section-padding">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-12 mb-40">
                    <div class="block-contents text-center">
                        <div class="section-title">
                            <h5>review</h5>
                            <span>Testimonials</span>
                            <h2>Client <span>Feedbacks</span></h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 col-xl-4 col-12">
                    <div class="single-testimonial-card text-center">
                        <div class="client-img bg-cover bg-center" style="background-image: url('assets/img/blog/author2.jpg')"></div>
                        <div class="client-info">
                            <h4>Thomas Smith</h4>
                            <span>CEO & Engineer</span>
                        </div>
                        <div class="feedback">
                            <p>Great experience and impressive product. It was a very professional and technically competent job from the whole team.</p>
                            <div class="star">
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-xl-4 col-12">
                    <div class="single-testimonial-card text-center">
                        <div class="client-img bg-cover bg-center" style="background-image: url('assets/img/blog/author3.jpg')"></div>
                        <div class="client-info">
                            <h4>Ernest Smith</h4>
                            <span>Business Man</span>
                        </div>
                        <div class="feedback">
                            <p>Great experience and impressive product. It was a very professional and technically competent job from the whole team.</p>
                            <div class="star">
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-xl-4 col-12">
                    <div class="single-testimonial-card text-center">
                        <div class="client-img bg-cover bg-center" style="background-image: url('assets/img/blog/author_img.jpg')"></div>
                        <div class="client-info">
                            <h4>Salman Ahmed</h4>
                            <span>Project Manager</span>
                        </div>
                        <div class="feedback">
                            <p>Great experience and impressive product. It was a very professional and technically competent job from the whole team.</p>
                            <div class="star">
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                                <span class="fas fa-star"></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div class="video-pop-up-wrapper section-padding bg-cover" style="background-image: url('assets/img/full-video-bg.jpg')">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center d-flex justify-content-center align-items-center">
                    <div class="video-play-btn">
                        <a href="https://www.youtube.com/watch?v=E1xkXZs0cAQ" class="popup-video play-video"><i class="fas fa-play"></i></a>                     
                    </div>
                </div>
            </div>
        </div>
    </div>
    <section class="brand-showcase-funfact-wrapper section-padding bg-contain bg-center" style="background-image: url('assets/img/dot_map.png')">
        <div class="container">
            <div class="col-12 text-center mb-20 mtm-20">
                <div class="mask-outline bg-center" style="background-image: url('assets/img/mask-bg.jpg')">
                    <h1>20,8700</h1>
                </div>
                <h6 class="mt-4">All-over delivery done by our team</h6>
            </div>
            <div class="row d-flex justify-content-center align-items-center">
                <div class="col-md-4 col-lg-3 col-12">
                    <div class="single-brand-logo">
                        <img src="assets/img/brand/1.png" alt="unitcargologistics">
                    </div>
                </div>
                <div class="col-md-4 col-lg-3 col-12">
                    <div class="single-brand-logo">
                        <img src="assets/img/brand/2.png" alt="unitcargologistics">
                    </div>
                </div>
                <div class="col-md-4 col-lg-3 col-12">
                    <div class="single-brand-logo">
                        <img src="assets/img/brand/3.png" alt="unitcargologistics">
                    </div>
                </div>
                <div class="col-md-4 col-lg-3 col-12">
                    <div class="single-brand-logo">
                        <img src="assets/img/brand/4.png" alt="unitcargologistics">
                    </div>
                </div>
                <div class="col-md-4 col-lg-3 col-12">
                    <div class="single-brand-logo">
                        <img src="assets/img/brand/5.png" alt="unitcargologistics">
                    </div>
                </div>
                <div class="col-md-4 col-lg-3 col-12">
                    <div class="single-brand-logo">
                        <img src="assets/img/brand/6.png" alt="unitcargologistics">
                    </div>
                </div>
                <div class="col-md-4 col-lg-3 col-12">
                    <div class="single-brand-logo">
                        <img src="assets/img/brand/7.png" alt="unitcargologistics">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="cta-wrapper section-padding bg-overlay bg-cover" style="background-image: url('assets/img/cta-bg.jpg')">
        <div class="container">
            <div class="col-lg-8 offset-lg-2 col-12 text-center">
                <div class="cta-contents">
                    <h1 class="text-white mt-5 mb-4">World’s Leading Contract Logistics Provider </h1>
                    
                </div>
            </div>
        </div>
    </section>
    <section class="latest-blog-wrapper section-bg section-padding">
        <div class="container">
            <div class="block-contents mb-30">
                <div class="section-title">
                    <h5 class="textleft">news</h5>
                    <span>News Feeds</span>
                    <h2>Blog & <span>Insights</span></h2>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-4 col-md-6 col-12">
                    <div class="single-news-card bg-cover" style="background-image: url('assets/img/blog/b1.jpg')">
                        <div class="contents">
                            <div class="post-cat-date d-flex align-items-center">
                                <div class="post-cat">
                                    <a href="news.html">Transport</a>
                                    <a href="news.html">Delivery</a>
                                </div>
                                <div class="post-date">
                                    June 21, 2021
                                </div>
                            </div>
                            <h5><a href="news-details.html">Means of transportation is
                                of the different kinds transport
                                facilities used.</a></h5>
                            <div class="post-author">
                                <div class="author-img bg-cover bg-center" style="background-image: url('assets/img/blog/author2.jpg')"></div>
                                <div class="author-info">
                                    <h6>Alaxis D. Dowson</h6>
                                    <span>Author</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-12">
                    <div class="single-news-card active bg-cover" style="background-image: url('assets/img/blog/b1.jpg')">
                        <div class="contents">
                            <div class="post-cat-date d-flex align-items-center">
                                <div class="post-cat">
                                    <a href="news.html">logistics</a>
                                    <a href="news.html">package</a>
                                </div>
                                <div class="post-date">
                                    December 31, 2021
                                </div>
                            </div>
                            <h5><a href="news-details.html">Road, air and sea transport are available. Air transport is the best way</a></h5>
                            <div class="post-author">
                                <div class="author-img bg-cover bg-center" style="background-image: url('assets/img/blog/author3.jpg')"></div>
                                <div class="author-info">
                                    <h6>Salman Ahmed</h6>
                                    <span>Author</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-12">
                    <div class="single-news-card bg-cover" style="background-image: url('assets/img/blog/b1.jpg')">
                        <div class="contents">
                            <div class="post-cat-date d-flex align-items-center">
                                <div class="post-cat">
                                    <a href="news.html">Transport</a>
                                    <a href="news.html">Delivery</a>
                                </div>
                                <div class="post-date">
                                    May 05, 2022
                                </div>
                            </div>
                            <h5><a href="news-details.html">Key Logistics Trends in Life  Sciences 2021. 5 Benefits of Working with a Broker</a></h5>
                            <div class="post-author">
                                <div class="author-img bg-cover bg-center" style="background-image: url('assets/img/blog/author2.jpg')"></div>
                                <div class="author-info">
                                    <h6>Alaxis D. Dowson</h6>
                                    <span>Author</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section> 
    <footer class="footer-1 footer-wrap">
        <div class="footer-widgets-wrapper theme-bg">
            <div class="container">
                <div class="row">
                    <div class="col-sm-6 col-xl-3">
                        <div class="about-unitcargologic pe-md-5 pe-xl-0">
                            <a href="index.php">
                                <img src="assets/img/footer-logo.png" alt="unitcargologistics">
                            </a>
                            <p style="color:white">Unitcargologistics Services is a global supplier of transport and logistics solutions. We have offices in more than 20 countries and agents.</p>
                        </div>
                    </div>
                    <div class="col-sm-6 col-xl-2">
                        <div class="single-footer-wid ps-xl-4">
                            <div class="wid-title">
                                <h6>Our Divisions</h6>
                            </div>
                            <ul>
                                <li><a href="about.html">What We Do</a></li>
                                <li><a href="contact.html">Request a Freight</a></li>
                                <li><a href="services.html">Track & Trace</a></li>
                                <li><a href="services.html">Rail Freight</a></li>
                                <li><a href="services.html">Maritime Transport</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-sm-6 col-xl-2">
                        <div class="single-footer-wid ps-xl-2">
                            <div class="wid-title">
                                <h6>Our Services</h6>
                            </div>
                            <ul>
                                <li><a href="#">What We Do</a></li>
                                <li><a href="#">Request a Freight</a></li>
                                <li><a href="#">Track & Trace</a></li>
                                <li><a href="#">Rail Freight</a></li>
                                <li><a href="#">Maritime Transport</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-sm-6 col-xl-2">
                        <div class="single-footer-wid">
                            <div class="wid-title">
                                <h6>Industry Sectors</h6>
                            </div>
                            <ul>
                                <li><a href="#">Electronics Industry</a></li>
                                <li><a href="#">Manufacturing</a></li>
                                <li><a href="#">Semicon & Solar</a></li>
                                <li><a href="#">Oil & Gas Cargo</a></li>
                                <li><a href="#">Energy & Chemicals</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-sm-6 col-xl-3">
                        <div class="single-footer-wid site-info-widget">
                            <div class="wid-title">
                                <h6>Get In Touch</h6>
                            </div>
                            <div class="get-in-touch">
                                <div class="single-contact-info">
                                    <div class="icon id1">
                                        <i class="fal fa-map-marker-alt"></i>
                                    </div>
                                    <div class="contact-info">
                                        <span>17 Stella-klein-low Weg, Vienna, Vienna, 1020, Austria</span>
                                    </div>
                                </div>
                                <div class="single-contact-info">
                                    <div class="icon id2">
                                        <i class="fal fa-phone"></i>
                                    </div>
                                    <div class="contact-info">
                                        <span>+1-215-539-5263</span>
                                    </div>
                                </div>
                                <div class="single-contact-info">
                                    <div class="icon id3">
                                        <i class="fal fa-envelope"></i>
                                    </div>
                                    <div class="contact-info">
                                        <span>unitcargologistics@gmail.com</span>
                                    </div>
                                </div>
                            </div>
                            <div class="newsletter_widget">
                                <div class="newsletter_box">
                                    <form action="#">
                                        <input type="email" placeholder="Enter email address" required>
                                        <button class="submit-btn" type="submit"><i class="fas fa-envelope-open"></i></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Track Shipping</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form action="https://bluegatecargo.com/search/currier" method="post">
        <input type="hidden" name="_token" value="y4Z3GAKsrLLvnVoS916O9SscarlrsEVdpFUdv8Gg">          
        <div class="form-group">
           <label for="exampleInputEmail1">Track Shipping</label>
           <input type="text" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder="Enter Tracking Code" name="currier_invoice" value="">
          </div>
         <button type="submit" class="btn btn-primary">Track</button>
        </form>
      </div>
    </div>
  </div>
</div>
        <div class="footer-bottom">
            <div class="container align-items-center">
                <div class="bottom-content-wrapper">
                    <div class="row">
                        <div class="col-md-6 col-12">
                            <div class="copy-rights">
                                <p>&copy;2022 <strong>unitcargologistics</strong>, All Rights Reserved</p>
                            </div>
                        </div>
                        <div class="col-md-6 mt-2 mt-md-0 col-12 text-md-end">
                            <div class="social-links">
                                <a href="#"><i class="fab fa-facebook-f"></i></a>
                                <a href="#"><i class="fab fa-twitter"></i></a>
                                <a href="#"><i class="fab fa-instagram"></i></a>
                                <a href="#"><i class="fab fa-youtube"></i></a>
                                <a href="#"><i class="fab fa-linkedin"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>   
    <!--  ALl JS Plugins
    ====================================== -->
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/modernizr.min.js"></script>
    <script src="assets/js/jquery.easing.js"></script>
    <script src="assets/js/popper.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <script src="assets/js/imageload.min.js"></script>
    <script src="assets/js/scrollUp.min.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/slick-animation.min.js"></script>
    <script src="assets/js/magnific-popup.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/metismenu.js"></script>
    <script src="assets/js/nice-select2.js"></script>
    <script src="assets/js/active.js"></script>
<script type="text/javascript">
    (function () {
        var options = {
            whatsapp: "+12155395263", // WhatsApp number with country code
            call_to_action: "Message us", // Call to action
            position: "left", // Position may be 'right' or 'left'
        };
        var proto = document.location.protocol, host = "getbutton.io", url = proto + "//static." + host;
        var s = document.createElement('script'); s.type = 'text/javascript'; s.async = true; s.src = url + '/widget-send-button/js/init.js';
        s.onload = function () { WhWidgetSendButton.init(host, proto, options); };
        var x = document.getElementsByTagName('script')[0]; x.parentNode.insertBefore(s, x);
    })();
</script>
