<?php

    include_once('connection.php');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Search Form</title>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 7);
            z-index: 1;
        }

        .modal-content{
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: #fff;
            padding: 20px;
            border: 1px solid #333;
            border-radius: 5px;
        }

        .result-item {
            margin: 5px 0;
        }

        .close-button{
            float: right;
            cursor: pointer;
        }
    </style>
</head>
<body>

 <?php
    // Check if the form was submitted
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        // Retrieve the submitted ID
        $trackid = $_POST["trackid"];

        

        // Check the connection
        if ($con->connect_error) {
            die("Connection failed: " . $con->connect_error);
        }

        // Query the database to retrieve the data (replace with your actual query)
        $sql = "SELECT * FROM consignment_details WHERE trackid = ?";
        $stmt = $con->prepare($sql);
        $stmt->bind_param("s", $trackid);
        $stmt->execute();
        $result = $stmt->get_result();

        // Display the fetched data in a pop-up box

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            echo "<b>CONSIGNMENT DETAILS</b>";
            echo "<div class='results-container'>";
            echo "<div class='result-item'>Track Id:" . $row["trackid"] . "</div>";
            echo "<div class='result-item'>Courier:" . $row["courier"] . "</div>";
            echo "<div class='result-item'>Package:" . $row["package"] . "</div>";
            echo "<div class='result-item'>Mode:" . $row["mode"] . "</div>";
            echo "<div class='result-item'>Product:" . $row["product"] . "</div>";
            echo "<div class='result-item'>Quantity:" . $row["quantity"] . "</div>";
            echo "<div class='result-item'>Total Freight:" . $row["totalfreight"] . "</div>";
            echo "<div class='result-item'>COURIER Ref No:" . $row["crn"] . "</div>";
            echo "<form method='post' action='index.php' class='close-form'>
            <input type='submit' value='close and go back'>
            </form>";
            
            // Add more fields as needed
            echo "</div>";
        } else {
            echo "No data found for ID: $trackid";
        }

        // Close the database connection
        $stmt->close();
        $con->close();
    }
    ?>

    <!-- JavaScript to show the modal -->
    <script>
        <?php if ($_SERVER["REQUEST_METHOD"] == "POST" && $result->num_rows > 0) { ?>
        document.addEventListener("DOMContentLoaded", function() {
            var modal = document.querySelector('.modal');
            modal.style.display = 'block';
        });
        <?php } ?>

        function closeModal() {
            var modal = document.querySelector('.modal');
            modal.style.display = 'none';
        }
    </script>
    
</body>
</html>