<?php

    $servername = "localhost";
    $username = "root";
    $password = "";
    $database = "unitcargologistics";


?>



<!DOCTYPE html>
<html>
<head>
    <title>Search Form</title>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 7);
            z-index: 1;


        }

        .modal-content{
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: #fff;
            padding: 20px;
            border: 1px solid #333;
            border-radius: 5px;
        }

        .result-item {
            margin: 5px 0;
        }

        .close-button{
            float: right;
            cursor: pointer;
        }
    </style>
</head>
<body>

    <?php
    // Check if the form was submitted
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        // Retrieve the submitted ID
        $trackid = $_POST["trackid"];

        // Establish a database connection (replace with your database credentials)
        $conn = new mysqli($servername, $username, $password, $database);

        // Check the connection
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }

        // Query the database to retrieve the data (replace with your actual query)
        $sql = "SELECT * FROM consignment_details WHERE trackid = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $trackid);
        $stmt->execute();
        $result = $stmt->get_result();

        // Display the fetched data in a pop-up box

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            echo "Consignment Details";
            echo "<div class='results-container'>";
            echo "<span class='close-button' onclick='closeModal()'>&times;</span>";
            echo "<div class='result-item'><strong>TRACK ID:</strong>" . $row["trackid"] . "</div>";
            echo "<div class='result-item'><strong>COURIER:</strong>" . $row["courier"] . "</div>";
            echo "<div class='result-item'><strong>PACKAGE:</strong>" . $row["package"] . "</div>";
            echo "<div class='result-item'><strong>MODE:</strong>" . $row["mode"] . "</div>";
            echo "<div class='result-item'><strong>PRODUCT:</strong>" . $row["product"] . "</div>";
            echo "<div class='result-item'><strong>QUANTITY:</strong>" . $row["quantity"] . "</div>";
            echo "<div class='result-item'><strong>TOTAL FREIGHT:</strong>" . $row["totalfreight"] . "</div>";
            echo "<div class='result-item'><strong>COURIER REF NO:</strong>" . $row["crn"] . "</div>";
            echo "<form method='post' action='index.php' class='close-form'>
            <input type='submit' value='close and go back'>
            </form>";
            
            // Add more fields as needed
            echo "</div>";
        } else {
            echo "No data found for ID: $trackid";
        }

        // Close the database connection
        $stmt->close();
        $conn->close();
    }
    ?>

    <!-- JavaScript to show the modal -->
    <script>
        <?php if ($_SERVER["REQUEST_METHOD"] == "POST" && $result->num_rows > 0) { ?>
        document.addEventListener("DOMContentLoaded", function() {
            var modal = document.querySelector('.modal');
            modal.style.display = 'block';
        });
        <?php } ?>

        function closeModal() {
            var modal = document.querySelector('.modal');
            modal.style.display = 'none';
        }
    </script>
   
    <!-- Modal to display results -->
    <div class="modal">
        <div class="modal-content">
            <h2>Consignment Details</h2>
            <div class="results-container">
                <!-- Results will be displayed here -->
                <div class="result-item"><strong>TRACK ID:</strong> <?= $row["trackid"] ?></div>
                <div class="result-item"><strong>COURIER</strong> <?= $row["courier"] ?></div>
                <div class="result-item"><strong>PACKAGE</strong> <?= $row["package"] ?></div>
                <div class="result-item"><strong>MODE:</strong> <?= $row["mode"] ?></div>
                <div class="result-item"><strong>PRODUCT:</strong> <?= $row["product"] ?></div>
                <div class="result-item"><strong>QUANTITY:</strong> <?= $row["quantity"] ?></div>
                <div class="result-item"><strong>TOTALFREIGHT:</strong> <?= $row["totalfreight"] ?></div>
                <div class="result-item"><strong>COURIER REF NO:</strong> <?= $row["crn"] ?></div>
                <!-- Add more fields as needed -->
            </div>
        </div>
    </div>
</body>
</html>